/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.


	$Id: pgpMisc.h,v 1.1 1999/09/14 19:10:55 cpeterson Exp $
____________________________________________________________________________*/

#ifndef	_pgpMisc_h
#define _pgpMisc_h

#define	MUTEX		0
#define SPINLOCK	1

PVOID
pgpDriverSecureAlloc (
		ULONG	ulNumBytes);

VOID
pgpDriverSecureFree (
		PVOID p);

VOID
pgpDriverEnterCriticalSection (
		PVOID	pSection,
		ULONG	ulType);

ULONG
pgpDriverTryToEnterCriticalSection (
		PVOID	pSection,
		ULONG	ulType);

VOID
pgpDriverLeaveCriticalSection (
		PVOID	pSection,
		ULONG	ulType);

VOID
pgpDriverInitCriticalSection (
		PVOID	pSection);

VOID
pgpDriverCleanupCriticalSection (
		PVOID	pSection);

VOID
pgpDriverGetHiResTime (
		PULONG	pulLowPart);

#endif //_pgpMisc_h